<?php
session_start();
require_once __DIR__.'/../api/db.php';
if(!isset($_SESSION['user_id'])){ header('Location: index.php'); exit; }
$uid = $_SESSION['user_id'];
$stmt = $pdo->prepare('SELECT * FROM users WHERE id = ? LIMIT 1');
$stmt->execute([$uid]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);
?>
<!doctype html><html><head><meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1"><title>Growfi - Dashboard</title>
<link rel="stylesheet" href="css/style.css"></head><body>
<div class="wrap">
  <aside class="sidebar">
    <div class="brand"><span class="logo">G</span> Growfi</div>
    <nav>
      <a class="active">Dashboard</a>
      <a href="my_wallet.php">My Wallet</a>
      <a href="my_income.php">My Income</a>
      <?php if($_SESSION['is_admin']): ?>
        <a href="/admin/">Admin Panel</a>
      <?php endif; ?>
      <a href="logout.php">Logout</a>
    </nav>
  </aside>
  <main class="main">
    <header class="topbar">
      <div>Welcome, <?=htmlspecialchars($user['user_id'])?></div>
      <div>Available Fund - <span id="availableFund">0.00$</span></div>
    </header>
    <section class="content">
      <div class="profilecard">
        <div class="avatar">👤</div>
        <div><strong>User Code:</strong> <?=htmlspecialchars($user['user_id'])?><br>
        <strong>Sponsor:</strong> <?=htmlspecialchars($user['sponsor_id'])?></div>
      </div>

      <h3>Your Dashboard</h3>
      <div class="cards" id="cardsGrid"></div>
    </section>
  </main>
</div>
<script>
const cards = ['MLC RRISE: $0.00','STAKING INCOME: $0.00','AVAILABLE MLC: $0.00','TODAY\'S INCOME: $0.00','REFERRAL INCOME: $0.00','LEVEL INCOME: $0.00'];
const grid = document.getElementById('cardsGrid');
cards.forEach(c=>{ const [t,v] = c.split(':'); const el = document.createElement('div'); el.className='card'; el.innerHTML=`<div class="icon">G</div><h4>${t}</h4><div class="value">${v}</div>`; grid.appendChild(el); });
</script>
</body></html>