-- Growfi SQL ready for import
-- Generated: 2025-10-15 18:51:17

CREATE DATABASE IF NOT EXISTS growfi_db;
USE growfi_db;

CREATE TABLE IF NOT EXISTS users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  sponsor_id VARCHAR(50) NOT NULL,
  user_id VARCHAR(50) NOT NULL UNIQUE,
  name VARCHAR(100),
  email VARCHAR(100),
  password VARCHAR(255) NOT NULL,
  join_date DATETIME DEFAULT CURRENT_TIMESTAMP,
  role ENUM('user','admin') DEFAULT 'user',
  status ENUM('active','inactive') DEFAULT 'active'
);

CREATE TABLE IF NOT EXISTS wallet (
  id INT AUTO_INCREMENT PRIMARY KEY,
  user_id VARCHAR(50) NOT NULL,
  available_balance DECIMAL(10,2) DEFAULT 0.00,
  staking_income DECIMAL(10,2) DEFAULT 0.00,
  referral_income DECIMAL(10,2) DEFAULT 0.00,
  level_income DECIMAL(10,2) DEFAULT 0.00,
  created_at DATETIME DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE IF NOT EXISTS referrals (
  id INT AUTO_INCREMENT PRIMARY KEY,
  sponsor_id VARCHAR(50) NOT NULL,
  referred_user_id VARCHAR(50) NOT NULL,
  date DATETIME DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE IF NOT EXISTS transactions (
  id INT AUTO_INCREMENT PRIMARY KEY,
  user_id VARCHAR(50) NOT NULL,
  type ENUM('staking','withdraw','deposit','reward') NOT NULL,
  amount DECIMAL(10,2) DEFAULT 0.00,
  description TEXT,
  date DATETIME DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE IF NOT EXISTS admin_activity (
  id INT AUTO_INCREMENT PRIMARY KEY,
  admin_id VARCHAR(50) NOT NULL,
  activity TEXT,
  date DATETIME DEFAULT CURRENT_TIMESTAMP
);

-- Seeded accounts -- ADMIN and a sample SPONSOR
INSERT INTO users (sponsor_id, user_id, name, email, password, join_date, role, status) VALUES
('ROOT', 'ADMIN001', 'Super Admin', 'admin@growfi.com', '$2y$12$PZbPvDAb4eeB1nL4hiuR2OYmt8y6DWp83txy5VUBBf8bdfuQYxZlO', NOW(), 'admin', 'active'),
('ADMIN001', 'SPONSOR01', 'Sample Sponsor', 'sponsor@growfi.com', '$2y$12$7G6q8h3YqvKj9Z0a1B2cDeFGHIJkLmnOPqRsTuVWxYz0123456789.', NOW(), 'user', 'active');

-- Create wallets for seeded users
INSERT INTO wallet (user_id, available_balance) VALUES
('ADMIN001', 0.00),
('SPONSOR01', 0.00);
